#############################################################################
##
## Copyright (C) 2021 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:COMM$
##
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtAxContainer, except for defaults which are replaced by "...".
"""

# Module PySide2.QtAxContainer
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtAxContainer


class QAxBase(Shiboken.Object):

    def __init__(self) -> None: ...

    def __lshift__(self, s: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, s: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @staticmethod
    def argumentsToList(var1: typing.Any, var2: typing.Any, var3: typing.Any, var4: typing.Any, var5: typing.Any, var6: typing.Any, var7: typing.Any, var8: typing.Any) -> typing.List[typing.Any]: ...
    def asVariant(self) -> typing.Any: ...
    def classContext(self) -> int: ...
    def className(self) -> bytes: ...
    def clear(self) -> None: ...
    def control(self) -> str: ...
    def disableClassInfo(self) -> None: ...
    def disableEventSink(self) -> None: ...
    def disableMetaObject(self) -> None: ...
    @typing.overload
    def dynamicCall(self, name: bytes, v1: typing.Any = ..., v2: typing.Any = ..., v3: typing.Any = ..., v4: typing.Any = ..., v5: typing.Any = ..., v6: typing.Any = ..., v7: typing.Any = ..., v8: typing.Any = ...) -> typing.Any: ...
    @typing.overload
    def dynamicCall(self, name: bytes, vars: typing.Sequence[typing.Any]) -> typing.Any: ...
    def fallbackMetaObject(self) -> PySide2.QtCore.QMetaObject: ...
    def generateDocumentation(self) -> str: ...
    def indexOfVerb(self, verb: str) -> int: ...
    def initializeFrom(self, that: PySide2.QtAxContainer.QAxBase) -> None: ...
    def internalRelease(self) -> None: ...
    def isNull(self) -> bool: ...
    def propertyBag(self) -> typing.Dict[str, typing.Any]: ...
    def propertyWritable(self, arg__1: bytes) -> bool: ...
    def qObject(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def querySubObject(self, name: bytes, v1: typing.Any = ..., v2: typing.Any = ..., v3: typing.Any = ..., v4: typing.Any = ..., v5: typing.Any = ..., v6: typing.Any = ..., v7: typing.Any = ..., v8: typing.Any = ...) -> PySide2.QtAxContainer.QAxObject: ...
    @typing.overload
    def querySubObject(self, name: bytes, vars: typing.Sequence[typing.Any]) -> PySide2.QtAxContainer.QAxObject: ...
    def setClassContext(self, classContext: int) -> None: ...
    def setControl(self, arg__1: str) -> bool: ...
    def setPropertyBag(self, arg__1: typing.Dict[str, typing.Any]) -> None: ...
    def setPropertyWritable(self, arg__1: bytes, arg__2: bool) -> None: ...
    def verbs(self) -> typing.List[str]: ...


class QAxObject(PySide2.QtCore.QObject, PySide2.QtAxContainer.QAxBase):

    @typing.overload
    def __init__(self, c: str, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def className(self) -> bytes: ...
    def doVerb(self, verb: str) -> bool: ...
    def fallbackMetaObject(self) -> PySide2.QtCore.QMetaObject: ...
    def qObject(self) -> PySide2.QtCore.QObject: ...


class QAxScript(PySide2.QtCore.QObject):
    FunctionNames            : QAxScript.FunctionFlags = ... # 0x0
    FunctionSignatures       : QAxScript.FunctionFlags = ... # 0x1

    class FunctionFlags(Shiboken.Enum):
        FunctionNames            : QAxScript.FunctionFlags = ... # 0x0
        FunctionSignatures       : QAxScript.FunctionFlags = ... # 0x1

    def __init__(self, name: str, manager: PySide2.QtAxContainer.QAxScriptManager) -> None: ...

    @typing.overload
    def call(self, function: str, arguments: typing.Sequence[typing.Any]) -> typing.Any: ...
    @typing.overload
    def call(self, function: str, v1: typing.Any = ..., v2: typing.Any = ..., v3: typing.Any = ..., v4: typing.Any = ..., v5: typing.Any = ..., v6: typing.Any = ..., v7: typing.Any = ..., v8: typing.Any = ...) -> typing.Any: ...
    def functions(self, arg__1: PySide2.QtAxContainer.QAxScript.FunctionFlags = ...) -> typing.List[str]: ...
    def load(self, code: str, language: str = ...) -> bool: ...
    def scriptCode(self) -> str: ...
    def scriptEngine(self) -> PySide2.QtAxContainer.QAxScriptEngine: ...
    def scriptName(self) -> str: ...


class QAxScriptEngine(PySide2.QtAxContainer.QAxObject):
    Uninitialized            : QAxScriptEngine.State = ... # 0x0
    Started                  : QAxScriptEngine.State = ... # 0x1
    Connected                : QAxScriptEngine.State = ... # 0x2
    Disconnected             : QAxScriptEngine.State = ... # 0x3
    Closed                   : QAxScriptEngine.State = ... # 0x4
    Initialized              : QAxScriptEngine.State = ... # 0x5

    class State(Shiboken.Enum):
        Uninitialized            : QAxScriptEngine.State = ... # 0x0
        Started                  : QAxScriptEngine.State = ... # 0x1
        Connected                : QAxScriptEngine.State = ... # 0x2
        Disconnected             : QAxScriptEngine.State = ... # 0x3
        Closed                   : QAxScriptEngine.State = ... # 0x4
        Initialized              : QAxScriptEngine.State = ... # 0x5

    def __init__(self, language: str, script: PySide2.QtAxContainer.QAxScript) -> None: ...

    def addItem(self, name: str) -> None: ...
    def hasIntrospection(self) -> bool: ...
    def isValid(self) -> bool: ...
    def scriptLanguage(self) -> str: ...
    def setState(self, st: PySide2.QtAxContainer.QAxScriptEngine.State) -> None: ...
    def state(self) -> PySide2.QtAxContainer.QAxScriptEngine.State: ...


class QAxScriptManager(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def addObject(self, object: PySide2.QtAxContainer.QAxBase) -> None: ...
    @typing.overload
    def call(self, function: str, arguments: typing.Sequence[typing.Any]) -> typing.Any: ...
    @typing.overload
    def call(self, function: str, v1: typing.Any = ..., v2: typing.Any = ..., v3: typing.Any = ..., v4: typing.Any = ..., v5: typing.Any = ..., v6: typing.Any = ..., v7: typing.Any = ..., v8: typing.Any = ...) -> typing.Any: ...
    def functions(self, arg__1: PySide2.QtAxContainer.QAxScript.FunctionFlags = ...) -> typing.List[str]: ...
    @typing.overload
    def load(self, code: str, name: str, language: str) -> PySide2.QtAxContainer.QAxScript: ...
    @typing.overload
    def load(self, file: str, name: str) -> PySide2.QtAxContainer.QAxScript: ...
    @staticmethod
    def registerEngine(name: str, extension: str, code: str = ...) -> bool: ...
    def script(self, name: str) -> PySide2.QtAxContainer.QAxScript: ...
    @staticmethod
    def scriptFileFilter() -> str: ...
    def scriptNames(self) -> typing.List[str]: ...


class QAxSelect(PySide2.QtWidgets.QDialog):
    SandboxingNone           : QAxSelect.SandboxingLevel = ... # 0x0
    SandboxingProcess        : QAxSelect.SandboxingLevel = ... # 0x1
    SandboxingLowIntegrity   : QAxSelect.SandboxingLevel = ... # 0x2

    class SandboxingLevel(Shiboken.Enum):
        SandboxingNone           : QAxSelect.SandboxingLevel = ... # 0x0
        SandboxingProcess        : QAxSelect.SandboxingLevel = ... # 0x1
        SandboxingLowIntegrity   : QAxSelect.SandboxingLevel = ... # 0x2

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., flags: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def clsid(self) -> str: ...
    def sandboxingLevel(self) -> PySide2.QtAxContainer.QAxSelect.SandboxingLevel: ...


class QAxWidget(PySide2.QtWidgets.QWidget, PySide2.QtAxContainer.QAxBase):

    @typing.overload
    def __init__(self, c: str, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ..., f: PySide2.QtCore.Qt.WindowFlags = ...) -> None: ...

    def changeEvent(self, e: PySide2.QtCore.QEvent) -> None: ...
    def className(self) -> bytes: ...
    def clear(self) -> None: ...
    @typing.overload
    def createHostWindow(self, arg__1: bool) -> bool: ...
    @typing.overload
    def createHostWindow(self, arg__1: bool, arg__2: PySide2.QtCore.QByteArray) -> bool: ...
    def doVerb(self, verb: str) -> bool: ...
    def fallbackMetaObject(self) -> PySide2.QtCore.QMetaObject: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def qObject(self) -> PySide2.QtCore.QObject: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def translateKeyEvent(self, message: int, keycode: int) -> bool: ...

# eof
